
The use of non-short-circuit logic in a boolean context is likely a mistake - one that could cause serious program errors as conditions are evaluated under the wrong circumstances.

## Noncompliant Code Example


    If GetTrue() Or GetFalse() Then ' Noncompliant; both sides evaluated
    End If


## Compliant Solution


    If GetTrue() OrElse GetFalse() Then ' true short-circuit logic
    End If


## See

- [CERT, EXP46-C.](https://www.securecoding.cert.org/confluence/x/g4FtAg) - Do not use a bitwise operator with a Boolean-like operand<br>

