
Because parameter names could be changed during refactoring, they should not be spelled out literally in strings. Instead, use `NameOf()`, and the string that's output will always be correct.

This rule raises an issue when any string in the `Throw` statement is an exact match for the name of one of the method parameters.

## Noncompliant Code Example


    Public Sub DoSomething(param As Integer, secondParam As String)
        If (param &lt; 0)
            Throw New Exception("param") ' Noncompliant
        End If
        If secondParam is Nothing
          Throw New Exception("secondParam should be valid") ' Noncompliant
        End If
    End Sub


## Compliant Solution


    Public Sub DoSomething(param As Integer, secondParam As String)
        If (param &lt; 0)
            Throw New Exception(NameOf(param))
        End If
        If secondParam is Nothing
          Throw New Exception($"{NameOf(secondParam)} should be valid")
        End If
    End Sub


## Exceptions

- The rule doesn't raise any issue when using VB.NET &lt; 14.0.
- When the parameter name is contained in a sentence inside the `Throw` statement string, the rule will raise an issue only if the<br>  parameter name is at least 5 characters long. This is to avoid false positives.

