
Shared coding conventions allow teams to collaborate efficiently. This rule checks that all namespace names match a provided regular expression.

The default configuration is the one recommended by Microsoft:

- Pascal casing, starting with an upper case character, e.g. Microsoft, System
- Short abbreviations of 2 letters can be capitalized, e.g. System.IO
- Longer abbreviations need to be lower cased


## Noncompliant Code Example

With the default regular expression: `^([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?(\.([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2}))*$`


    Namespace foo  ' Noncompliant
    End Namespace


## Compliant Solution


    Namespace Foo  ' Compliant
    End Namespace

