
A `Do ... Loop` without a `While` or `Until` condition must be terminated by an unstructured `Exit Do` statement. It is safer and more readable to use structured loops instead.

## Noncompliant Code Example


    Module Module1
        Sub Main()
            Dim i = 1
    
            Do                        ' Non-Compliant
                If i = 10 Then
                    Exit Do
                End If
    
                Console.WriteLine(i)
    
                i = i + 1
            Loop
        End Sub
    End Module


## Compliant Solution


    Module Module1
        Sub Main()
            For i = 1 To 9            ' Compliant
                Console.WriteLine(i)
            Next
        End Sub
    End Module

