
Shared coding conventions allow teams to collaborate efficiently. This rule checks that all even names match a provided regular expression.

The default configuration is the one recommended by Microsoft:

- Pascal casing, starting with an upper case character, e.g. BackColor
- Short abbreviations of 2 letters can be capitalized, e.g. GetID
- Longer abbreviations need to be lower cased, e.g. GetHtml


## Noncompliant Code Example

With the default regular expression `^([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?$`:


    Class Foo
        Event fooEvent() ' Noncompliant
    End Class


## Compliant Solution


    Class Foo
        Event FooEvent() ' Compliant
    End Class

