
Shared coding conventions allow teams to collaborate efficiently. This rule checks that all `Private` field names match the provided regular expression.

Note that this rule does not apply to `Private Shared ReadOnly` fields, which are checked by another rule.

The default configuration is:

- Optionally, can start with an underscore character or "s\_", e.g. *foo, s*foo
- Camel casing, starting with a lower case character, e.g. backColor
- Short abbreviations of 2 letters can be capitalized only when not at the beginning, e.g. "id" in productID
- Longer abbreviations need to be lower cased, e.g. html


## Noncompliant Code Example

With the default regular expression `^(s_|_)?[a-z][a-z0-9]*([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?$`:


    Class Foo
        Private Foo As Integer  ' Noncompliant
    End Class


## Compliant Solution


    Class Foo
        Private foo As Integer  ' Compliant
    End Class

