
Shared naming conventions allow teams to collaborate efficiently. This rule checks that all generic type parameter names match a provided regular expression.

The default configuration is the one recommended by Microsoft:

- Must start with an upper case 'T' character, e.g. T
- Followed by Pascal casing, starting with an upper case character, e.g. TKey
- Short abbreviations of 2 letters can be capitalized, e.g. TFooID
- Longer abbreviations need to be lower cased, e.g. TFooHtml


## Noncompliant Code Example

With the default parameter value `^T(([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?)?$`:


    Public Class Foo(Of t) ' Noncompliant
    End Class


## Compliant Solution


    Public Class Foo(Of T) ' Compliant
    End Class

