
Using the `With` statement for a series of calls to the same object makes the code more readable.

## Noncompliant Code Example

With the default value of 6:


    Module Module1
        Dim product = New With {.Name = "paperclips", .RetailPrice = 1.2, .WholesalePrice = 0.6, .A = 0, .B = 0, .C = 0}
    
        Sub Main()
            product.Name = ""           ' Noncompliant
            product.RetailPrice = 0
            product.WholesalePrice = 0
            product.A = 0
            product.B = 0
            product.C = 0
        End Sub
    End Module


## Compliant Solution


    Module Module1
        Dim product = New With {.Name = "paperclips", .RetailPrice = 1.2, .WholesalePrice = 0.6, .A = 0, .B = 0, .C = 0}
    
        Sub Main()
            With product
                .Name = ""
                .RetailPrice = 0
                .WholesalePrice = 0
                .A = 0
                .B = 0
                .C = 0
            End With
        End Sub
    End Module

