
Shared resources should not be used for locking as it increases the chance of deadlocks. Any other thread could acquire (or attempt to acquire) the same lock for another unrelated purpose.

Instead, a dedicated `object` instance should be used for each shared resource, to avoid deadlocks or lock contention.

The following objects are considered as shared resources:

- `Me`
- a `Type` object
- a string literal
- a string instance


## Noncompliant Code Example


    Public Sub MyLockingMethod()
        SyncLock Me 'Noncompliant
            ' ...
        End SyncLock
    End Sub


## Compliant Solution


    Class MyClass
        Dim lockObj As New Object()
    
        Public Sub MyLockingMethod()
            SyncLock lockObj
                ' ...
            End SyncLock
        End Sub
    End Class


## See

[Microsoft Documentation: Managed Threading<br>Best Practices](https://docs.microsoft.com/en-us/dotnet/standard/threading/managed-threading-best-practices)
