
A `Catch` clause that only rethrows the caught exception has the same effect as omitting the `Catch` altogether and letting it bubble up automatically, but with more code and the additional detriment of leaving maintainers scratching their heads.

Such clauses should either be eliminated or populated with the appropriate logic.

## Noncompliant Code Example


    Dim s As String = ""
    Try
        s = File.ReadAllText(fileName)
    Catch e As Exception
        Throw
    End Try


## Compliant Solution


    Dim s As String = ""
    Try
        s = File.ReadAllText(fileName)
    Catch e As Exception
        logger.LogError(e)
        Throw
    End Try


or


    Dim s As String = File.ReadAllText(fileName)


## Exceptions

This rule will not generate issues for `Catch` blocks with just `Throw` inside if they are followed by a `Catch` block for a more general exception type that does more than just rethrowing the exception.


    Dim s As String = ""
    Try
        s = File.ReadAllText(fileName)
    Catch e As IOException 'Compliant, if removed will change the logic
        Throw
    Catch e As Exception 'Compliant, does more than just rethrow
        logger.LogError(e)
        Throw
    End Try

