
This rule raises an issue when reflection is used to change the visibility of a class, method or field, and when it is used to directly update a field value. Altering or bypassing the accessibility of classes, methods, or fields violates the encapsulation principle and could lead to run-time errors.

## Noncompliant Code Example


    Imports System.Reflection
    
    Dim dynClass = Type.GetType("MyInternalClass")
    ' Sensitive. Using BindingFlags.NonPublic will return non-public members
    Dim bindingAttr As BindingFlags = BindingFlags.NonPublic Or BindingFlags.Static
    Dim dynMethod As MethodInfo = dynClass.GetMethod("mymethod", bindingAttr)
    Dim result = dynMethod.Invoke(dynClass, Nothing)


## See

- [CERT, SEC05-J.](https://www.securecoding.cert.org/confluence/x/3YEVAQ) - Do not use reflection to increase accessibility of<br>  classes, methods, or fields

