
Just because you *can* do something, doesn't mean you should, and that's the case with nested ternary operations. Nesting ternary operators results in the kind of code that may seem clear as day when you write it, but six months later will leave maintainers (or worse - future you) scratching their heads and cursing.

Instead, err on the side of clarity, and use another line to express the nested operation as a separate statement.

## Noncompliant Code Example


    Public Function GetTitle(ByVal p As Person) As String
        Return If(p.Gender = Gender.MALE, "Mr. ", If(p.IsMarried, "Mrs. ", "Miss ")) ' Noncompliant
    End Function


## Compliant Solution


    Public Function GetTitle(ByVal p As Person) As String
        If p.Gender = Gender.MALE Then
            Return "Mr. "
        End If
    
        Return If(p.IsMarried, "Mrs. ", "Miss ")
    End Function

