
Other than `Exit Select`, using an `Exit` statement is never a good idea.

`Exit Do`, `Exit For`, `Exit Try`, and `Exit While` will all result in unstructured control flow, i.e. spaghetti code.

`Exit Function`, `Exit Property`, and `Exit Sub` are all poor, less-readable substitutes for a simple `return`, and if used with code that should return a value (`Exit Function` and in some cases `Exit Property`) they could result in a `NullReferenceException`.

This rule raises an issue for all uses of `Exit` except `Exit Select` and `Exit Do` statements in loops without condition.

## Noncompliant Code Example


    Public Class Sample
      Dim condition As Boolean
    
      Public Sub MySub()
        If condition Then
          Exit Sub                  ' Noncompliant
        End If
    
        For index = 1 To 10
          If index = 5 Then
              Exit For               ' Noncompliant
          End If
          ' ...
        Next
      End Sub
      Function MyFunction() As Object
        ' ...
        MyFunction = 42
        Exit Function              ' Noncompliant
      End Function
    End Class


## Compliant Solution


    Public Class Sample
      Dim condition As Boolean
    
      Public Sub MySub()
        If condition Then
            Return
        End If
    
        For index = 1 To 4
            ' ...
        Next
      End Sub
      Function MyFunction() As Object
        ' ...
        Return 42
      End Function
    End Class

