
Marking a method with the `Pure` attribute specifies that the method doesn't make any visible changes; thus, the method should return a result, otherwise the call to the method should be equal to no-operation. So `Pure` on a `void` method is either a mistake, or the method doesn't do any meaningful task.

## Noncompliant Code Example


    Class Person
        Private age As Integer
    
        &lt;Pure&gt; ' Noncompliant. In this case the method makes a possibly visible state change
        Private Sub ConfigureAge(ByVal age As Integer)
            ...
            Me.age = age
        End Sub
    End Class


## Compliant Solution


    Class Person
        Private age As Integer
    
        Private Sub ConfigureAge(ByVal age As Integer)
            Me.age = age
        End Sub
    End Class

