
Visual Basic .NET offers a non-short-circuit conditional function, `IIf()`, which returns either its second or third parameter based on the expression in the first parameter. Using it is slower than using `If()` because each parameter is unconditionally evaluated. Further, its use can lead to runtime exceptions because `IIf` always evaluates all three of its arguments.

The newer version, `If()`, should be used instead because it short-circuits the evaluation of its parameters.

## Noncompliant Code Example


    Public Class Foo
        Public Sub Bar()
            Dim var As Object = IIf(Date.Now.Year = 1999, "Lets party!", "Lets party like it is 1999!") ' Noncompliant
        End Sub
    End Class


## Compliant Solution


    Public Class Foo
        Public Sub Bar()
            Dim var As String = If(Date.Now.Year = 1999, "Lets party!", "Lets party like it is 1999!")
        End Sub
    End Class


## See

- [IIf Function (MSDN)](https://msdn.microsoft.com/en-us/library/27ydhh0d%28v=vs.90%29.aspx)
- [If Operator (MSDN)](https://msdn.microsoft.com/en-us/library/bb513985%28v=vs.90%29.aspx)

