
For clarity, all overloads of the same method should be grouped together. That lets both users and maintainers quickly understand all the current available options.

## Noncompliant Code Example


    Interface IMyInterface
        Function DoTheThing() As Integer
        Function DoTheOtherThing() As String // Noncompliant
        Function DoTheThing(ByVal Path As String) As Integer
    End Interface


## Compliant Solution


    Interface IMyInterface
        Function DoTheThing() As Integer
        Function DoTheThing(ByVal Path As String) As Integer
        Function DoTheOtherThing() As String
    End Interface


## Exceptions

As it is common practice to group method declarations by implemented interface, no issue will be raised for interface implementations if grouped together with other members of that interface.

As it is also a common practice to group method declarations by accessibility level, no issue will be raised for method overloads having different access modifiers.

Example:


    Class MyClass
    
        Private Sub DoTheThing(s As String) ' Ok - this method is declared as Private while the other one is Public
            ' ...
        End Sub
    
        Private Sub DoTheOtherThing(s As String)
            ' ...
        End Sub
    
        Public Sub DoTheThing()
            ' ...
        End Sub
    
    End Class

