
There are valid cases for passing a variable multiple times into the same method call, but usually doing so is a mistake, and something else was intended for one of the arguments.

## Noncompliant Code Example


    If compare(myPoint.x, myPoint.x) &lt;&gt; 0 Then ' Noncompliant
        '...
    End If
    
    If compare(getNextValue(), getNextValue()) &lt;&gt; 0 Then ' Noncompliant
        '...
    End If


## Compliant Solution


    If compare(myPoint.x, myPoint.y) &lt;&gt; 0 Then
        '...
    End If
    
    Dim v1 As Integer = getNextValue()
    Dim v2 As Integer = getNextValue()
    If compare(v1, v2) &lt;&gt; 0 Then
        '...
    End If


## Deprecated

This rule is deprecated, and will eventually be removed.
