
Properties provide a way to enforce encapsulation by providing `public`, `protected` or `internal` methods that give controlled access to `private` fields. However in classes with multiple fields it is not unusual that cut and paste is used to quickly create the needed properties, which can result in the wrong field being accessed by a getter or setter.

This rule raises an issue in any of these cases:

- A setter does not update the field with the corresponding name.
- A getter does not access the field with the corresponding name.


For simple properties it is better to use [auto-implemented<br>properties](https://docs.microsoft.com/en-us/dotnet/visual-basic/programming-guide/language-features/procedures/auto-implemented-properties) (VB.NET 10.0 or later).

Field and property names are compared as case-insensitive. All underscore characters are ignored.

## Noncompliant Code Example


    Class A
        Private x As Integer
        Private y As Integer
    
        Public Property X As Integer
            Get
                Return x
            End Get
            Set(ByVal value As Integer)
                x = value
            End Set
        End Property
    
        Public Property Y As Integer
            Get  ' Noncompliant: field 'y' is not used in the return value
                Return x
            End Get
            Set(ByVal value As Integer) ' Noncompliant: field 'y' is not updated
                x = value
            End Set
        End Property
    End Class


## Compliant Solution


    Class A
        Private x As Integer
        Private y As Integer
    
        Public Property X As Integer
            Get
                Return x
            End Get
            Set(ByVal value As Integer)
                x = value
            End Set
        End Property
    
        Public Property Y As Integer
            Get
                Return y
            End Get
            Set(ByVal value As Integer)
                y = value
            End Set
        End Property
    End Class

