
Marking a class with `PartCreationPolicy(CreationPolicy.Shared)`, which is part of Managed Extensibility Framework (MEF), means that a single, shared instance of the exported object will be created. Therefore it doesn't make sense to create new instances using the constructor and it will most likely result in unexpected behaviours.

This rule raises an issue when a constructor of a class marked shared with a `PartCreationPolicyAttribute` is invoked.

## Noncompliant Code Example


    &lt;Export(GetType(IFooBar))&gt;
    &lt;PartCreationPolicy(CreationPolicy.[Shared])&gt;
    Public Class FooBar
        Inherits IFooBar
    End Class
    
    Public Class Program
        Public Shared Sub Main()
            Dim fooBar = New FooBar() ' Noncompliant
        End Sub
    End Class


## Compliant Solution


    &lt;Export(GetType(IFooBar))&gt;
    &lt;PartCreationPolicy(CreationPolicy.[Shared])&gt;
    Public Class FooBar
        Inherits IFooBar
    End Class
    
    Public Class Program
        Public Shared Sub Main()
            Dim fooBar = serviceProvider.GetService(Of IFooBar)()
        End Sub
    End Class

