
Validation of X.509 certificates is essential to create secure SSL/TLS sessions not vulnerable to man-in-the-middle attacks.

The certificate chain validation includes these steps:

- The certificate is issued by its parent Certificate Authority or the root CA trusted by the system.
- Each CA is allowed to issue certificates.
- Each certificate in the chain is not expired.


It's not recommended to reinvent the wheel by implementing custom certificate chain validation.

TLS libraries provide built-in certificate validation functions that should be used.

## Noncompliant Code Example


    ServicePointManager.ServerCertificateValidationCallback =
        Function(sender, certificate, chain, errors) True ' Noncompliant: trust all certificates


## Compliant Solution


    ServicePointManager.ServerCertificateValidationCallback =
        Function(sender, certificate, chain, errors)
            If Development Then Return True ' For development, trust all certificates
            Return Errors = SslPolicyErrors.None AndAlso ValidCerts.Contains(certificate.GetCertHashString()) ' Compliant: trust only some certificates
        End Function


## See

- [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure<br>
- [OWASP Top 10 2017 Category A6](https://www.owasp.org/index.php/Top_10-2017_A6-Security_Misconfiguration) - Security<br>  Misconfiguration
- [MITRE, CWE-295](https://cwe.mitre.org/data/definitions/295.html) - Improper Certificate Validation

