
The access control of an application must be properly implemented in order to restrict access to resources to authorized entities otherwise this could lead to vulnerabilities:

- [CVE-2018-12999](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-12999)
- [CVE-2018-10285](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-10285)
- [CVE-2017-7455](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-7455)


Granting correct permissions to users, applications, groups or roles and defining required permissions that allow access to a resource is sensitive, must therefore be done with care. For instance, it is obvious that only users with administrator privilege should be authorized to add/remove the administrator permission of another user.

## Ask Yourself Whether

- Granted permission to an entity (user, application) allow access to information or functionalities not needed by this entity.
- Privileges are easily acquired (eg: based on the location of the user, type of device used, defined by third parties, does not require approval<br>  ...).
- Inherited permission, default permission, no privileges (eg: anonymous user) is authorized to access to a protected resource.


You are at risk if you answered yes to any of those questions.

## Recommended Secure Coding Practices

At minimum, an access control system should:

- Use a well-defined access control model like [RBAC](https://en.wikipedia.org/wiki/Role-based_access_control) or [ACL](https://en.wikipedia.org/wiki/Access-control_list).
- Entities' permissions should be reviewed regularly to remove permissions that are no longer needed.
- Respect [the principle of least privilege](https://en.wikipedia.org/wiki/Principle_of_least_privilege) ("\_an entity has access only<br>  the information and resources that are necessary for its legitimate purpose\_").


## Sensitive Code Example


    Imports System.Threading
    Imports System.Security.Permissions
    Imports System.Security.Principal
    Imports System.IdentityModel.Tokens
    
    Class SecurityPrincipalDemo
        Class MyIdentity
            Implements IIdentity ' Sensitive, custom IIdentity implementations should be reviewed
        End Class
    
        Class MyPrincipal
            Implements IPrincipal ' Sensitive, custom IPrincipal implementations should be reviewed
        End Class
    
        &lt;System.Security.Permissions.PrincipalPermission(SecurityAction.Demand, Role:="Administrators")&gt; ' Sensitive. The access restrictions enforced by this attribute should be reviewed.
        Private Shared Sub CheckAdministrator()
            Dim MyIdentity As WindowsIdentity = WindowsIdentity.GetCurrent() ' Sensitive
    
            HttpContext.User = ... ' Sensitive: review all reference (set and get) to System.Web HttpContext.User
    
            Dim domain As AppDomain = AppDomain.CurrentDomain
            domain.SetPrincipalPolicy(PrincipalPolicy.WindowsPrincipal) ' Sensitive
    
            Dim identity As MyIdentity = New MyIdentity() ' Sensitive
            Dim MyPrincipal As MyPrincipal = New MyPrincipal(MyIdentity) ' Sensitive
            Thread.CurrentPrincipal = MyPrincipal ' Sensitive
            domain.SetThreadPrincipal(MyPrincipal) ' Sensitive
    
            Dim principalPerm As PrincipalPermission = New PrincipalPermission(Nothing, "Administrators")  ' Sensitive
            principalPerm.Demand()
    
            Dim handler As SecurityTokenHandler = ...
            Dim identities As ReadOnlyCollection(Of ClaimsIdentity) = handler.ValidateToken()  ' Sensitive, this creates identity
        End Sub
    
        ' Sensitive: review how this function uses the identity and principal.
        Private Sub modifyPrincipal(ByVal identity As MyIdentity, ByVal principal As MyPrincipal)
        End Sub
    End Class


## See

- [OWASP Top 10 2017 Category A5](https://www.owasp.org/index.php/Top_10-2017_A5-Broken_Access_Control) - Boken Access Control
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat3) - Porous Defenses
- [MITRE, CWE-276](https://cwe.mitre.org/data/definitions/276.html) - Incorrect Default Permissions
- [MITRE, CWE-732](https://cwe.mitre.org/data/definitions/732.html) - Incorrect Permission Assignment for Critical Resource
- [MITRE, CWE-668](https://cwe.mitre.org/data/definitions/668.html) - Exposure of Resource to Wrong Sphere
- [MITRE, CWE-277](https://cwe.mitre.org/data/definitions/277.html) - Insecure Inherited Permissions

