
If a JSON Web Token (JWT) is not signed with a strong cipher algorithm (or not signed at all) an attacker can forge it and impersonate user identities.

- Don't use `none` algorithm to sign or verify the validity of an algorithm.
- Don't use a token without verifying its signature before.


## Noncompliant Code Example

[jwt-dotnet](https://github.com/jwt-dotnet/jwt) library:


    Dim decodedtoken1 As String = decoder.Decode(token, secret, verify:= false) ' Noncompliant: signature should be verified
    
    Dim decodedtoken2 As String = new JwtBuilder().
    &nbsp; &nbsp; WithSecret(secret).
    &nbsp; &nbsp; Decode(forgedtoken1) ' Noncompliant: signature should be verified


## Compliant Solution

[jwt-dotnet](https://github.com/jwt-dotnet/jwt) library:


    Dim decodedtoken1 As String = decoder.Decode(forgedtoken1, secret, verify:= true) ' Compliant
    
    Dim decodedtoken2 As String = new JwtBuilder().
    &nbsp; &nbsp; WithSecret(secret).
    &nbsp; &nbsp; MustVerifySignature().
    &nbsp; &nbsp; Decode(token) ' Compliant


## See

- [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure<br>
- [MITRE, CWE-347](https://cwe.mitre.org/data/definitions/347.html) - Improper Verification of Cryptographic Signature

