/*
 * Decompiled with CFR 0.152.
 */
package com.codacy.plugins.utils;

import better.files.File$;
import com.codacy.plugins.utils.Log$;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class FileHelper$ {
    public static FileHelper$ MODULE$;
    private final Codec codec;

    static {
        new FileHelper$();
    }

    public Codec codec() {
        return this.codec;
    }

    public String toRelativePath(String rootDirectory, String filePath) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(filePath)).stripPrefix(rootDirectory))).stripPrefix(File.separator);
    }

    public List<String> toRelativePath(String rootDirectory, List<String> paths) {
        return (List)paths.map((Function1 & Serializable & scala.Serializable)p -> MODULE$.toRelativePath(rootDirectory, (String)p), List$.MODULE$.canBuildFrom());
    }

    public Option<List<String>> read(File file) {
        Option option;
        Option sourceOpt = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Source$.MODULE$.fromFile(file, MODULE$.codec())).toOption().orElse((Function0 & Serializable & scala.Serializable)() -> {
            Log$.MODULE$.warn(new StringBuilder(21).append("Failed to open file: ").append(file.getAbsolutePath()).toString());
            return None$.MODULE$;
        });
        try {
            try {
                option = sourceOpt.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getLines().toList());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (option2.isEmpty()) {
                    throw throwable;
                }
                Log$.MODULE$.warn(new StringBuilder(21).append("Failed to read file: ").append(file.getAbsolutePath()).toString());
                None$ none$ = None$.MODULE$;
                option = none$;
            }
        }
        finally {
            sourceOpt.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.close();
                return BoxedUnit.UNIT;
            });
        }
        return option;
    }

    public <T> Try<T> usingNewFile(Option<File> basedir, String prefix, String suffix, String content, Function1<Path, T> f) {
        String x$1 = prefix;
        String x$2 = suffix;
        Option x$3 = basedir.map((Function1 & Serializable & scala.Serializable)d -> File$.MODULE$.apply(d.getPath(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
        Seq x$4 = File$.MODULE$.newTemporaryFile$default$4(x$1, x$2, x$3);
        better.files.File file = File$.MODULE$.newTemporaryFile(x$1, x$2, x$3, x$4);
        Try res = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            PosixFilePermission x$5 = PosixFilePermission.OWNER_READ;
            Seq x$6 = file.addPermission$default$2(x$5);
            better.files.File qual$1 = file.addPermission(x$5, x$6);
            PosixFilePermission x$7 = PosixFilePermission.GROUP_READ;
            Seq x$8 = qual$1.addPermission$default$2(x$7);
            better.files.File qual$2 = qual$1.addPermission(x$7, x$8);
            PosixFilePermission x$9 = PosixFilePermission.OTHERS_READ;
            Seq x$10 = qual$2.addPermission$default$2(x$9);
            better.files.File qual$3 = qual$2.addPermission(x$9, x$10);
            String x$11 = content;
            Seq x$12 = qual$3.write$default$2(x$11);
            Charset x$13 = qual$3.write$default$3(x$11);
            qual$3.write(x$11, x$12, x$13);
            return f.apply((Object)file.path());
        });
        file.delete(true);
        return res;
    }

    private FileHelper$() {
        MODULE$ = this;
        this.codec = Codec$.MODULE$.apply("UTF-8");
        this.codec().onMalformedInput(CodingErrorAction.REPLACE);
        this.codec().onUnmappableCharacter(CodingErrorAction.REPLACE);
    }
}

