## Broken SSL version

### Problematic:


```python
ssl.wrap_socket(ssl_version=ssl.PROTOCOL_SSLv3)
```


### Correct:

```python
#PROTOCOL_TLS Selects the highest protocol version that both the client and server support.
ssl.wrap_socket(ssl_version=ssl.PROTOCOL_TLS)
```

### Rationale:

Several highly publicized exploitable flaws have been discovered in all versions of SSL and early versions of TLS. 
It is strongly recommended that use of the following known broken protocol versions be avoided:
* SSL v2
* SSL v3
* TLS v1
* TLS v1.1

[Reference](https://docs.openstack.org/bandit/latest/plugins/b502_ssl_with_bad_version.html)