## Avoid starting a process with a partial path

Python possesses many mechanisms to invoke an external executable. 
If the desired executable path is not fully qualified relative to the filesystem root then this may present a potential security risk.
This test will scan the parameters of all configured Python methods, looking for paths that do not start at the filesystem root, that is, do not have a leading ‘/’ character.

[Reference](https://docs.openstack.org/bandit/latest/plugins/b607_start_process_with_partial_path.html)