### AvoidLargeClassesRule
This rule allows developers to measure the classes size. When a class is trying to doing a lot of work, then you probabily have the Large Class smell. This rule will fire if a type contains too many fields (over 25 by default) or has fields with common prefixes. If the rule does fire then the type should be reviewed to see if new classes should be extracted from it.

**Bad** example:

``` csharp
public class MyClass {
    int x, x1, x2, x3;
    string s, s1, s2, s3;
    DateTime bar, bar1, bar2;
    string[] strings, strings1;
}
```
**Good** example:

``` csharp
public class MyClass {
    int x;
    string s;
    DateTime bar;
}
```