### AvoidRedundancyInMethodNameRule
This rule will fire if a method name embeds the type name of its first parameter. Usually, removing that type name makes the API less verbose, easier to learn, and more future-proof.

**Bad** example:

``` csharp
class PostOffice {
    public void SendLetter (Letter letter) {
    }
    public void SendPackage (Package package) {
    }
}
```
**Good** example:

``` csharp
class PostOffice {
    public void Send (Letter letter) {
    }
    public void Send (Package package) {
    }
}
```
**Bad** example:

``` csharp
class PostOffice {
    public static bool IsPackageValid (Package package) {
        return package.HasAddress && package.HasStamp;
    }
}
```
**Good** example:

``` csharp
class Package {
    public bool IsValid {
        get {
            return HasAddress && HasStamp;
        }
    }
}
```