### AvoidThrowingBasicExceptionsRule
This rule checks for methods that create basic exceptions like **System.Exception**, **System.ApplicationException** or **System.SystemException**. Those exceptions do not provide enough information about the error to be helpful to the consumer of the library.

**Bad** example:

``` csharp
public void Add (object obj)
{
    if (obj == null) {
        throw new Exception ();
    }
    Inner.Add (obj);
}
```
**Good** example:

``` csharp
public void Add (object obj)
{
    if (obj == null) {
        throw new ArgumentNullException ("obj");
    }
    Inner.Add (obj);
}
```
**Notes**

-   This rule is available since Gendarme 2.0
