### AvoidTypeInterfaceInconsistencyRule
This rule will fire if an assembly has a namespace which contains an interface IFoo and a type Foo, but the type does not implement the interface. If an interface and a type name differ only by the **I** prefix (of the interface) then we can logically expect the type to implement this interface.

**Bad** example:

``` csharp
public interface IMember {
    string Name {
        get;
    }
}
 
public class Member {
    public string Name {
        get {
            return String.Empty;
        }
    }
}
```
**Good** example:

``` csharp
public interface IMember {
    string Name {
        get;
    }
}
 
public class Member : IMember {
    public string Name {
        get {
            return String.Empty;
        }
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.4
