### AvoidUninstantiatedInternalClassesRule
This rule will fire if a type is only visible within its assembly, can be instantiated, but is not instantiated. Such types are often leftover (dead code) or are debugging/testing code and not required. However in some case the types might by needed, e.g. when accessed thru reflection or if the **[InternalsVisibleTo]** attribute is used on the assembly.

**Bad** example:

``` csharp
// defined, but never instantiated
internal class MyInternalClass {
    // ...
}
 
public class MyClass {
    static void Main ()
    {
        // ...
    }
}
```
**Good** example:

``` csharp
internal class MyInternalClass {
    // ...
}
 
public class MyClass {
    static void Main ()
    {
        MyInternalClass c = new MyInternalClass ();
        // ...
    }
}
```