### AvoidUnsealedConcreteAttributesRule
This rule fires if an attribute is defined which is both concrete (i.e. not abstract) and unsealed. This is a performance problem because it means that **System.Attribute.GetCustomAttribute** has to search the attribute type hierarchy for derived types. To fix this either seal the type or make it abstract.

**Bad** example:

``` csharp
[AttributeUsage (AttributeTargets.All)]
public class BadAttribute : Attribute {
}
```
**Good** example (sealed):

``` csharp
[AttributeUsage (AttributeTargets.All)]
public sealed class SealedAttribute : Attribute {
}
```
**Good** example (abstract and sealed):

``` csharp
[AttributeUsage (AttributeTargets.All)]
public abstract class AbstractAttribute : Attribute {
}
 
[AttributeUsage (AttributeTargets.All)]
public sealed class ConcreteAttribute : AbstractAttribute {
}
```
**Notes**

-   Before Gendarme 2.0 this rule was named AvoidUnsealedAttributesRule.
