### AvoidUnsealedUninheritedInternalTypeRule
This rule will fire for classes which are internal to the assembly and have no derived classes, but are not **sealed**. Sealing the type clarifies the type hierarchy and allows the compiler/JIT to perform optimizations such as eliding virtual method calls.

**Bad** example:

``` csharp
// this one is correct since MyInheritedStuff inherits from this class
internal class MyBaseStuff {
}
 
// this one is bad, since no other class inherit from MyConcreteStuff
internal class MyInheritedStuff : MyBaseStuff {
}
```
**Good** example:

``` csharp
// this one is correct since the class is abstract
internal abstract class MyAbstractStuff {
}
 
// this one is correct since the class is sealed
internal sealed class MyConcreteStuff : MyAbstractStuff {
}
```
**Notes**

-   This rule is available since Gendarme 2.0 and, before 2.2, was named AvoidUnsealedUninheritedInternalClassesRule
