### AvoidVisibleFieldsRule
This rule fires if a type contains externally visible fields. Instead use a property which allows you to change the implementation without breaking binary compatibility with other assemblies.

**Bad** example:

``` csharp
public class Foo {
    public int Value;
}
```
**Good** example:

``` csharp
public class Foo {
    private int v;
    public int Value {
        get {
            return v;
        }
        set {
            v = value;
        }
    }
```
**Notes**

-   Prior to Gendarme 2.2 this rule was named AvoidPublicInstanceFieldsRule.
