### CheckNewExceptionWithoutThrowingRule
This rule checks for exception objects which are created but not thrown, not returned, and not passed to another method as an argument.

**Bad** example:

``` csharp
void MissingThrow (object arg)
{
    if (arg == null) {
        new ArgumentNullException ("arg");
    }
    DoWork (arg);
}
```
**Good** examples:

``` csharp
void Throw (object arg)
{
    if (arg == null) {
        throw new ArgumentNullException ("arg");
    }
    DoWork (arg);
}
 
Exception CreateException ()
{
    return new Exception ();
}
```