### ConsiderCustomAccessorsForNonVisibleEventsRule
This rule looks for non-visible events to see if their add/remove accessors are the default ones. The default, compiler generated, accessor is marked as synchronized which means that the runtime will bracket them between **Monitor.Enter** and **Monitor.Exit** calls. This is the safest approach unless, for non-visible events, you have a performance bottleneck around the events. In this case you should review if your code needs the locks or if you can provide an alternative to them.

**Bad** example:

``` csharp
private event EventHandler<TestEventArgs> TimeCritical;
```
**Good** example:

``` csharp
static object TimeCriticalEvent = new object ();
EventHandlerList events = new EventHandlerList ();
 
private event EventHandler<TestEventArgs> TimeCritical {
    add {
        events.AddHandler (TimeCriticalEvent, value);
    }
    remove {
        events.AddHandler (TimeCriticalEvent, value);
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.0
