### DoNotDestroyStackTraceRule
This rule will fire if a catch handler throws the exception it caught. What it should do instead is rethrow the original exception (e.g. use **throw** instead of **throw ex**). This is helpful because rethrow preserves the stacktrace of the original exception.

**Bad** example:

``` csharp
try {
    Int32.Parse ("Broken!");
}
catch (Exception ex) {
    Assert.IsNotNull (ex);
    throw ex;
}
```
**Good** example:

``` csharp
try {
    Int32.Parse ("Broken!");
}
catch (Exception ex) {
    Assert.IsNotNull (ex);
    throw;
}
```
**Notes**

-   Prior to Gendarme 2.0 this rule was named DontDestroyStackTraceRule.
