### DoNotReduceTypeSecurityOnMethodsRule
This rule checks for types that have declarative security permission which aren't a subset of the security permission of some of their methods.

**Bad** example:

``` csharp
[SecurityPermission (SecurityAction.Assert, ControlThread = true)]
public class NotSubset {
    [EnvironmentPermission (SecurityAction.Assert, Unrestricted = true)]
    public void Method ()
    {
    }
}
```
**Good** example:

``` csharp
[SecurityPermission (SecurityAction.Assert, ControlThread = true)]
public class Subset {
    [SecurityPermission (SecurityAction.Assert, Unrestricted = true)]
    public void Method ()
    {
    }
}
```
**Notes**

-   Before Gendarme 2.2 this rule was part of Gendarme.Rules.Security and named TypeIsNotSubsetOfMethodSecurityRule.
