### DoNotUseGetInterfaceToCheckAssignabilityRule
This rule checks for calls to **Type.GetInterface** that look like they query if a type is supported, i.e. the result is only used to compare against **null**. The problem is that only assembly qualified names uniquely identify a type so if you just use the interface name or even just the name and namespace you may get unexpected results.

**Bad** example:

``` csharp
if (type.GetInterface ("IConvertible") != null)  {
    // then the type can be assigned to IConvertible
    // but what if there is another IConvertible in there ?!?
}
```
**Good** example:

``` csharp
if (typeof (IConvertible).IsAssignableFrom (type))  {
    // then the type can be assigned to IConvertible
    // without a doubt!
}
```
**Notes**

-   This rule is available since Gendarme 2.2
