### DoNotUseThreadStaticWithInstanceFieldsRule
This rule will fire if an instance field is decorated with a **[ThreadStatic]** attribute. This is an error because the attribute will only work with static fields.

**Bad** example:

``` csharp
// the field isn't static so this will do nothing
[ThreadStatic]
private List<object> items;
 
public void Add (object item)
{
    // If the field was thread safe this would ensure that each thread had
    // its own copy of the list.
    if (items == null) {
        items = new List<object> ();
    }
 
    items.Add (item);
}
```
**Good** example:

``` csharp
private List<object> items = new List<object> ();
private object mutex = new object ();
 
// Typically some form of locking such as the code below is used to
// serialize access to instance fields. However you can also use
// Threading.Thread.Thread::AllocateNamedDataSlot or AllocateDataSlot.
public void Add (object item)
{
    lock (mutex) {
        items.Add (item);
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.6
