### EnumsShouldUseInt32Rule
Enumaration types should avoid specifying a non-default storage type for their values unless it is required for interoperability (e.g. with native code). If you do use a non-default type for the enum, and the enum is externally visible, then prefer the CLS-compliant integral types: System.Byte, System.Int16, System.Int32, and System.Int64.

**Bad** examples:

``` csharp
public enum SmallEnum : byte {
    Zero,
    One
}
 
[Flags]
public enum SmallFlag : ushort {
    One = 1,
    // ...
    Sixteen = 1 << 15
}
```
**Good** example:

``` csharp
public enum SmallEnum {
    Zero,
    One
}
 
[Flags]
public enum SmallFlag {
    One = 1,
    // ...
    Sixteen = 1 << 15
}
```