### FlagsShouldNotDefineAZeroValueRule
This rule ensures that enumerations decorated with the [System.Flags] attribute do not contain a 0 value. This value would not be usable with bitwise operators.

**Bad** example (using 0 for a normal value):

``` csharp
[Flags]
[Serializable]
enum Access {
    Read = 0,
    Write = 1
}
```
**Bad** example (using None):

``` csharp
[Flags]
[Serializable]
enum Access {
    // this is less severe since the name of the 0 value helps
    None = 0,
    Read = 1,
    Write = 2
}
```
**Good** example:

``` csharp
[Flags]
[Serializable]
enum Access {
    Read = 1,
    Write = 2
}
```