### GetLastErrorMustBeCalledRightAfterPInvokeRule
This rule will fire if **Marshal.GetLastWin32Error()** is called, but is not called immediately after a P/Invoke. This is a problem because other methods, even managed methods, may overwrite the error code.

**Bad** example:

``` csharp
public void DestroyError ()
{
    MessageBeep (2);
    Console.WriteLine ("Beep");
    int error = Marshal.GetLastWin32Error ();
}
```
**Good** example:

``` csharp
public void GetError ()
{
    MessageBeep (2);
    int error = Marshal.GetLastWin32Error ();
    Console.WriteLine ("Beep");
}
 
public void DontUseGetLastError ()
{
    MessageBeep (2);
    Console.WriteLine ("Beep");
}
```