### ImplementEqualsAndGetHashCodeInPairRule
This rule checks for types that either override the **Equals(object)** method without overriding **GetHashCode()** or override **GetHashCode** without overriding **Equals**. In order to work correctly types should always override these together.

**Bad** example (missing GetHashCode):

``` csharp
public class MissingGetHashCode {
    public override bool Equals (object obj)
    {
        return this == obj;
    }
}
```
**Bad** example (missing Equals):

``` csharp
public class MissingEquals {
    public override int GetHashCode ()
    {
        return 42;
    }
}
```
**Good** example:

``` csharp
public class Good {
    public override bool Equals (object obj)
    {
        return this == obj;
    }
 
    public override int GetHashCode ()
    {
        return 42;
    }
}
```