### ImplementGenericCollectionInterfacesRule
This rule checks for types which implement the non-generic IEnumerable interface but not the IEnumerable\<T\> interface. Implementing the generic version of IEnumerable avoids casts, and possibly boxing, when iterating the collection.

**Bad** example:

``` csharp
public class IntEnumerable : IEnumerable {
    public IEnumerator GetEnumerator ()
    {
    }
}
```
**Good** example:

``` csharp
public class IntEnumerable : IEnumerable<int> {
    public IEnumerator<int> GetEnumerator ()
    {
    }
 
    IEnumerator IEnumerable.GetEnumerator ()
    {
    }
}
```
**Notes**

-   Before Gendarme 2.2 this rule was part of Gendarme.Rules.Design assembly.
