### MainShouldNotBePublicRule
This rule fires if an assembly's entry point (typically named **Main**) is visible to other assemblies. It is better to make this method private so that only the CLR can call the method.

**Bad** example:

``` csharp
public class MainClass {
    public void Main ()
    {
    }
}
```
**Good** example (type is not externally visible):

``` csharp
internal class MainClass {
    public void Main ()
    {
    }
}
```
**Good** example (method is not externally visible):

``` csharp
public class MainClass {
    internal void Main ()
    {
    }
}
```