### MarshalBooleansInPInvokeDeclarationsRule
This rule warns the developer if a **[MarshalAs]** attribute has not been specified for boolean parameters of a P/Invoke method. The size of boolean types varies across language (e.g. the C++ **bool** type is four bytes on some platforms and one byte on others). By default the CLR will marshal **System.Boolean**as a 32 bit value (**UnmanagedType.Bool**) like the Win32 API **BOOL**uses. But, for clarity, you should always specify the correct value.

**Bad** example:

``` csharp
// bad assuming the last parameter is a single byte being mapped to a bool
[DllImport ("liberty")]
private static extern bool Bad (bool b1, ref bool b2);
```
**Good** example:

``` csharp
[DllImport ("liberty")]
[return: MarshalAs (UnmanagedType.Bool)]
private static extern bool Good ([MarshalAs (UnmanagedType.Bool)] bool b1, [MarshalAs (UnmanagedType.U1)] ref bool b2);
```