### MissingAttributeUsageOnCustomAttributeRule
This rule verifies that every custom attribute (i.e. types that inherit from **System.Attribute**) is decorated with an **[AttributeUsage]** attribute to specify which kind of code instances of that custom attribute can be applied to.

**Bad** example:

``` csharp
// this applies to everything - but the meaning is not clear
public sealed class SomeAttribute : Attribute {
}
```
**Good** examples:

``` csharp
// this clearly applies to everything
[AttributeUsage (AttributeTargets.All)]
public sealed class AttributeApplyingToAnything : Attribute {
}
 
// while this applies only to fields
[AttributeUsage (AttributeTargets.Field)]
public sealed class AttributeApplyingToFields : Attribute {
}
```