### MissingSerializationConstructorRule
This rule checks for types that implement **System.ISerializable** but don't provide a serialization constructor. The constructor is required in order to make the type serializeable but cannot be enforced by the interface. The serialization constructor should be **private** for **sealed** types and **protected** for unsealed types.

**Bad** example:

``` csharp
[Serializable]
public class Bad : ISerializable {
    public void GetObjectData (SerializationInfo info, StreamingContext context)
    {
    }
}
```
**Good** example (sealed):

``` csharp
[Serializable]
public sealed class Good : ISerializable {
    private ClassWithConstructor (SerializationInfo info, StreamingContext context)
    {
    }
 
    public void GetObjectData (SerializationInfo info, StreamingContext context)
    {
    }
}
```
**Good** example:

``` csharp
[Serializable]
public class Good : ISerializable {
    protected ClassWithConstructor (SerializationInfo info, StreamingContext context)
    {
    }
 
    public void GetObjectData (SerializationInfo info, StreamingContext context)
    {
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.0
