### OverrideEqualsMethodRule
This rule warns when a type overloads the equality **==** operator but does not override the **Object.Equals** method.

**Bad** example:

``` csharp
class DoesNotOverrideEquals {
    public static bool operator == (DoesNotOverloadOperatorEquals a, DoesNotOverloadOperatorEquals b)
    {
        return true;
    }
}
```
**Good** example:

``` csharp
class OverridesEquals {
    public static bool operator == (OverridesEquals a, OverridesEquals b)
    {
        return true;
    }
 
    public override bool Equals (object obj)
    {
        OverridesEquals other = (obj as OverridesEquals);
        if (other == null) {
            return false;
        }
        return (this == other);
    }
}
```