### PreferEventsOverMethodsRule
This rule checks for method names that suggest they are providing similar functionality to .NET events. When possible the method(s) should be replaced with a real event. If the methods are not using or providing event-like features then they should be renamed since such names can confuse consumers about what the method is really doing.

**Bad** example:

``` csharp
public delegate void MouseUpCallback (int x, int y, MouseButtons buttons);
 
public class MouseController {
    private MouseUpCallback mouse_up_callback;
 
    public void RaiseMouseUp (Message msg)
    {
        if (mouse_up_callback != null) {
            mouse_up_callback (msg.X, msg.Y, msg.Buttons);
        }
    }
 
    public void ProcessMessage (Message msg)
    {
        switch (msg.Id) {
            case MessageId.MouseUp: {
                RaiseMouseUp (msg);
                break;
            }
            // ... more ...
            default:
            break;
        }
    }
}
```
**Good** example:

``` csharp
public class MouseController {
    public event EventHandler<MessageEvent> MouseUp;
 
    public void ProcessMessage (Message msg)
    {
        switch (msg.Id) {
            case MessageId.MouseUp: {
                EventHandler<MessageEvent> handler = MouseUp;
                if (handler != null) {
                    handler (new MessageEvent (msg));
                }
                break;
            }
            // ... more ...
            default:
            break;
        }
    }
}
```